/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.potion;

import javax.annotation.Nullable;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.torocraft.toroquest.potion.PotionLoyalty;
import net.torocraft.toroquest.potion.PotionRoyal;

public class TQPotionTypes {
    public static final PotionType ROYALTY;
    public static final PotionType ROYALTY_LONG;
    public static final PotionType ROYALTY_STRONG;
    public static final PotionType LOYALTY;
    public static final PotionType LOYALTY_LONG;
    public static final PotionType LOYALTY_STRONG;

    private static PotionType createPotionType(PotionEffect potionEffect) {
        return TQPotionTypes.createPotionType(potionEffect, null);
    }

    private static PotionType createPotionType(PotionEffect potionEffect, @Nullable String namePrefix) {
        ResourceLocation potionName = potionEffect.func_188419_a().getRegistryName();
        ResourceLocation potionTypeName = namePrefix != null ? new ResourceLocation(potionName.func_110624_b(), namePrefix + potionName.func_110623_a()) : potionName;
        return (PotionType)new PotionType(potionName.toString(), new PotionEffect[]{potionEffect}).setRegistryName(potionTypeName);
    }

    static {
        String LONG_PREFIX = "long_";
        String STRONG_PREFIX = "strong_";
        int HELPFUL_DURATION_STANDARD = 3600;
        int HELPFUL_DURATION_LONG = 9600;
        int HELPFUL_DURATION_STRONG = 1800;
        ROYALTY = TQPotionTypes.createPotionType(new PotionEffect((Potion)PotionRoyal.INSTANCE, 3600));
        ROYALTY_LONG = TQPotionTypes.createPotionType(new PotionEffect((Potion)PotionRoyal.INSTANCE, 9600), "long_");
        ROYALTY_STRONG = TQPotionTypes.createPotionType(new PotionEffect((Potion)PotionRoyal.INSTANCE, 1800, 1), "strong_");
        LOYALTY = TQPotionTypes.createPotionType(new PotionEffect((Potion)PotionLoyalty.INSTANCE, 3600));
        LOYALTY_LONG = TQPotionTypes.createPotionType(new PotionEffect((Potion)PotionLoyalty.INSTANCE, 9600), "long_");
        LOYALTY_STRONG = TQPotionTypes.createPotionType(new PotionEffect((Potion)PotionLoyalty.INSTANCE, 1800, 1), "strong_");
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerPotionTypes(RegistryEvent.Register<PotionType> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new PotionType[]{ROYALTY, ROYALTY_LONG, ROYALTY_STRONG, LOYALTY, LOYALTY_LONG, LOYALTY_STRONG});
        }
    }
}

