/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.util;

import com.google.common.base.Splitter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public abstract class Hud {
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((char)'\n');
    protected final Minecraft mc;
    protected RenderItem itemRender;
    protected final int width;
    protected final int height;
    protected final FontRenderer fontRenderer;

    public Hud(Minecraft mc, int width, int height) {
        this.mc = mc;
        this.itemRender = mc.func_175599_af();
        this.fontRenderer = mc.field_71466_p;
        if (this.fontRenderer == null) {
            throw new NullPointerException("fontRenderer is NULL");
        }
        this.width = width;
        this.height = height;
    }

    public abstract void render(int var1, int var2);

    protected void drawHorizontalLine(int startX, int endX, int y, int color) {
        if (endX < startX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        Hud.drawRect(startX, y, endX + 1, y + 1, color);
    }

    protected void drawVerticalLine(int x, int startY, int endY, int color) {
        if (endY < startY) {
            int i = startY;
            startY = endY;
            endY = i;
        }
        Hud.drawRect(x, startY + 1, x + 1, endY, color);
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public void drawCenteredString(String text, int x, int y, int color) {
        this.fontRenderer.func_175063_a(text, (float)(x - this.fontRenderer.func_78256_a(text) / 2), (float)y, color);
    }

    public void drawRightString(String text, int x, int y, int color) {
        this.fontRenderer.func_175063_a(text, (float)(x - this.fontRenderer.func_78256_a(text)), (float)y, color);
    }

    public void drawString(String text, int x, int y, int color) {
        this.fontRenderer.func_175063_a(text, (float)x, (float)y, color);
    }
}

