/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.util.generation;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.io.IOUtils;

public class BlockMap {
    private final BlockPos origin;
    private final World world;
    private String blockMap;
    private String[] lines;
    private String delimiter;
    private int lineIndex;
    private String line;
    private int y = -1;
    private int x;
    private int z;
    private int pass = 1;
    private int maxPass = 1;
    private Map<Character, PaletteEntry> palette;
    private boolean paletteParsed = false;
    private static final PaletteEntry DEFAULT_PALETTE_ENTRY = new PaletteEntry();

    public BlockMap(World world, BlockPos origin) {
        this.world = world;
        this.origin = origin;
    }

    public void loadLocalFile(String path) {
        InputStream is = this.getClass().getResourceAsStream(path);
        if (is == null) {
            throw new RuntimeException("file not found: " + path);
        }
        try {
            this.blockMap = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void generate() {
        this.palette = new HashMap<Character, PaletteEntry>();
        this.palette.put(Character.valueOf(' '), DEFAULT_PALETTE_ENTRY);
        this.splitIntoLines();
        this.parseDelimiter();
        this.pass = 1;
        while (this.pass <= this.maxPass) {
            System.out.println("starting block scan MAXPASS[" + this.maxPass + "] PASS[" + this.pass + "]");
            this.lineIndex = 1;
            while (this.lineIndex < this.lines.length) {
                this.line = this.lines[this.lineIndex];
                this.handleLine();
                ++this.lineIndex;
            }
            this.y = -1;
            ++this.pass;
        }
    }

    private void handleLine() {
        if (this.line == null) {
            return;
        }
        if (this.delimiter.equals(this.line)) {
            ++this.y;
            this.z = 0;
            return;
        }
        this.palette.put(Character.valueOf(' '), null);
        if (this.y < 0) {
            this.parsePalette();
        } else {
            this.paletteParsed = true;
            this.generateLine();
            ++this.z;
        }
    }

    private void parsePalette() {
        if (this.paletteParsed) {
            return;
        }
        if (this.line.length() < 3) {
            System.out.println("Invalid palette line [" + this.line + "]");
            return;
        }
        System.out.println("parsing palette line [" + this.line + "]");
        char c = this.line.substring(0, 1).toCharArray()[0];
        String blockType = this.line.substring(2);
        System.out.println("palette: [" + c + "][" + blockType + "]");
        this.palette.put(Character.valueOf(c), this.parsePaleteBlock(blockType));
    }

    private PaletteEntry parsePaleteBlock(String blockString) {
        PaletteEntry entry = new PaletteEntry();
        String[] a = blockString.split("\\|");
        entry.block = Block.func_149684_b((String)a[0]).func_176223_P();
        if (a[0].equals("minecraft:wooden_slab")) {
            entry.block = entry.block.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
        }
        if (a.length > 0) {
            for (int i = 1; i < a.length; ++i) {
                String propertyString = a[i];
                if (propertyString == null) continue;
                if (propertyString.matches("^\\(\\d+\\)$")) {
                    System.out.println("found pass number [" + propertyString + "]");
                    this.parsePaletePassNumber(propertyString, entry);
                    continue;
                }
                this.parsePaleteBlockParameter(a[0], propertyString, entry);
            }
        }
        return entry;
    }

    private void parsePaletePassNumber(String propertyString, PaletteEntry entry) {
        System.out.println("parsing pass [" + propertyString + "]");
        entry.pass = Integer.parseInt(propertyString.replaceAll("[^0-9]", ""), 10);
        this.maxPass = Math.max(this.maxPass, entry.pass);
    }

    private void parsePaleteBlockParameter(String blockname, String propertyString, PaletteEntry entry) {
        String[] aProp = propertyString.split(":");
        if (aProp.length != 2) {
            return;
        }
        PropertyDirection prop = null;
        EnumFacing value = null;
        if ("facing".equals(aProp[0])) {
            prop = blockname.equals("minecraft:torch") ? PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

                public boolean apply(EnumFacing p_apply_1_) {
                    return p_apply_1_ != EnumFacing.DOWN;
                }
            }) : BlockHorizontal.field_185512_D;
        }
        if ("north".equals(aProp[1])) {
            value = EnumFacing.NORTH;
        } else if ("south".equals(aProp[1])) {
            value = EnumFacing.SOUTH;
        }
        if (value == null || prop == null) {
            return;
        }
        System.out.println("adding property [" + aProp[0] + "] [" + aProp[1] + "]");
        entry.block = entry.block.func_177226_a((IProperty)prop, (Comparable)value);
    }

    private void parseDelimiter() {
        this.delimiter = this.lines[0];
        System.out.println("delim: [" + this.delimiter + "]");
    }

    private void splitIntoLines() {
        this.lines = this.blockMap.split("\n\r?");
    }

    private void generateLine() {
        char[] a;
        System.out.println("placing line PASS[" + this.pass + "] [" + this.line + "] [" + this.x + "][" + this.y + "][" + this.z + "]");
        this.x = 0;
        for (char c : a = this.line.toCharArray()) {
            this.placeBlock(c);
            ++this.x;
        }
    }

    private void placeBlock(char c) {
        if (c == ' ') {
            return;
        }
        PaletteEntry entry = this.palette.get(Character.valueOf(c));
        if (entry == null) {
            entry = DEFAULT_PALETTE_ENTRY;
            System.out.println("palette entry not found for [" + c + "]");
        }
        if (entry.pass != this.pass) {
            return;
        }
        this.world.func_180501_a(this.cursorCoords(), entry.block, 3);
    }

    private boolean onAirBlock() {
        IBlockState currentBlock = this.world.func_180495_p(this.cursorCoords());
        return !currentBlock.func_185914_p();
    }

    private BlockPos cursorCoords() {
        return this.origin.func_177982_a(this.x, this.y, this.z);
    }

    static {
        BlockMap.DEFAULT_PALETTE_ENTRY.block = Blocks.field_150350_a.func_176223_P();
        BlockMap.DEFAULT_PALETTE_ENTRY.pass = 1;
    }

    public static class PaletteEntry {
        IBlockState block;
        int pass = 1;
    }
}

