/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.util.generation;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.torocraft.toroquest.util.generation.ICanvas;
import net.torocraft.toroquest.util.generation.Style;

public class Canvas
implements ICanvas {
    private final World world;
    private final BlockPos origin;
    private int x;
    private int y;
    private int z;
    private Style style = new Style();
    private static final EnumFacing.Axis X = EnumFacing.Axis.X;
    private static final EnumFacing.Axis Y = EnumFacing.Axis.Y;
    private static final EnumFacing.Axis Z = EnumFacing.Axis.Z;

    public Canvas(World world, BlockPos origin) {
        this.world = world;
        this.origin = origin;
    }

    @Override
    public void setStyles(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    @Override
    public void moveTo(BlockPos pos) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    @Override
    public void rectangle(EnumFacing.Axis normalAxis, BlockPos pos, int width, int depth) {
        this.moveTo(pos);
        this.line(X, width);
        this.line(Z, depth);
        this.line(X, -width);
        this.line(Z, -depth);
    }

    @Override
    public void cuboid(BlockPos pos, int width, int height, int depth) {
        this.moveTo(pos);
        this.x = pos.func_177958_n();
        while (this.x < width) {
            this.y = pos.func_177956_o();
            while (this.y < height) {
                this.z = pos.func_177952_p();
                while (this.z < depth) {
                    this.fillBlock();
                    ++this.z;
                }
                ++this.y;
            }
            ++this.x;
        }
    }

    private void strokeBlock() {
        this.world.func_175656_a(this.cursorCoords(), this.style.stroke);
    }

    private void fillBlock() {
        this.world.func_175656_a(this.cursorCoords(), this.style.fill);
    }

    @Override
    public void line(EnumFacing.Axis axis, int length) {
        int l = this.computeTravelDistance(length);
        boolean isPositive = length >= 0;
        for (int i = 0; i < l; ++i) {
            this.strokeBlock();
            if (i >= l - 1) continue;
            if (isPositive) {
                this.incrementAxis(axis, 1);
                continue;
            }
            this.incrementAxis(axis, -1);
        }
    }

    private int computeTravelDistance(int length) {
        return Math.abs(length);
    }

    private void incrementAxis(EnumFacing.Axis axis, int amount) {
        switch (axis) {
            case X: {
                this.x += amount;
                break;
            }
            case Y: {
                this.y += amount;
                break;
            }
            case Z: {
                this.z += amount;
                break;
            }
        }
    }

    private boolean okToPlaceBlock() {
        return !this.style.ignoreOpaque || this.onAirBlock();
    }

    private boolean onAirBlock() {
        IBlockState currentBlock = this.world.func_180495_p(this.cursorCoords());
        return !currentBlock.func_185914_p();
    }

    private BlockPos cursorCoords() {
        return this.origin.func_177982_a(this.x, this.y, this.z);
    }
}

