/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class CustomHorseInfo {
    public final String name;
    public final String texture;
    public int[] powers;
    public int[] superchargedPowers;
    public String title;
    private boolean inMod = true;
    private AtomicBoolean ready = new AtomicBoolean(true);
    private AtomicBoolean defunct = new AtomicBoolean(true);
    private BufferedImage bufferedImage = null;

    public CustomHorseInfo(String name, String texture, int ... powers) {
        this.name = name;
        this.texture = texture;
        this.title = null;
        HashSet<Integer> powerSet = new HashSet<Integer>(powers.length);
        HashSet<Integer> superchargedPowerSet = new HashSet<Integer>(powers.length);
        this.makePowerSets(powerSet, superchargedPowerSet, powers);
        this.powers = new int[powerSet.size()];
        this.superchargedPowers = new int[superchargedPowerSet.size()];
        this.setPowerArray(this.powers, powerSet);
        this.setPowerArray(this.superchargedPowers, superchargedPowerSet);
    }

    public CustomHorseInfo(String name, String texture, String title, int ... powers) {
        this.name = name;
        this.texture = texture;
        this.title = title;
        HashSet<Integer> powerSet = new HashSet<Integer>(powers.length);
        HashSet<Integer> superchargedPowerSet = new HashSet<Integer>(powers.length);
        this.makePowerSets(powerSet, superchargedPowerSet, powers);
        this.powers = new int[powerSet.size()];
        this.superchargedPowers = new int[superchargedPowerSet.size()];
        this.setPowerArray(this.powers, powerSet);
        this.setPowerArray(this.superchargedPowers, superchargedPowerSet);
    }

    private void makePowerSets(Set<Integer> powerSet, Set<Integer> superchargedPowerSet, int ... powers) {
        for (int p : powers) {
            boolean added = powerSet.add(p);
            if (added) continue;
            superchargedPowerSet.add(p);
        }
        Object object = superchargedPowerSet.iterator();
        while (object.hasNext()) {
            int p = (Integer)object.next();
            powerSet.remove(p);
        }
    }

    private void setPowerArray(int[] powerArray, Set<Integer> powerSet) {
        int i = 0;
        Iterator<Integer> iterator = powerSet.iterator();
        while (iterator.hasNext()) {
            int p;
            powerArray[i] = p = iterator.next().intValue();
            ++i;
        }
    }

    public boolean isInMod() {
        return this.inMod;
    }

    public void setNotInMod() {
        this.inMod = false;
    }

    public boolean isReady() {
        return this.ready.get();
    }

    public void setReady(boolean tr) {
        this.ready.set(tr);
    }

    public boolean isDefunct() {
        return this.defunct.get();
    }

    public void setDefunct(boolean defunct) {
        this.defunct.set(defunct);
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setPowers(int ... powers) {
        HashSet<Integer> powerSet = new HashSet<Integer>(powers.length);
        HashSet<Integer> superchargedPowerSet = new HashSet<Integer>(powers.length);
        this.makePowerSets(powerSet, superchargedPowerSet, powers);
        this.powers = new int[powerSet.size()];
        this.superchargedPowers = new int[superchargedPowerSet.size()];
        this.setPowerArray(this.powers, powerSet);
        this.setPowerArray(this.superchargedPowers, superchargedPowerSet);
    }
}

