/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.custom.AbstractPower;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class EnderFlameAura
extends AbstractPower {
    public EnderFlameAura(boolean b) {
        super(b);
        this.name = I18n.func_74838_a((String)"power.enderFlameAura");
    }

    @Override
    public EntityMagicalHorse.OrderedPower getOrderedPower() {
        return EntityMagicalHorse.OrderedPower.RAINBOW_AURA;
    }

    @Override
    public void doAuraPower(EntityMagicalHorse horse, int auraCounter) {
        double auraWidth = 3.1;
        double auraHeight = 2.4;
        double xExp = 2.1;
        double up = 1.9;
        double zExp = 2.1;
        int fireTimeInSeconds = 2;
        int protTime = 180;
        int numParticles = 1;
        int modCount = 40;
        int amplifier = 1;
        if (this.supercharged) {
            auraWidth = 3.6;
            auraHeight = 3.1;
            fireTimeInSeconds = 5;
            numParticles = 2;
            protTime = 400;
            modCount = 30;
        }
        if (horse.field_70170_p.field_72995_K) {
            this.emitAura((Entity)horse, numParticles, xExp / 2.0, up / 2.0, zExp / 2.0);
        }
        if (auraCounter % modCount == 0) {
            for (Object e : horse.field_70170_p.func_72872_a(EntityLivingBase.class, horse.func_174813_aQ().func_72314_b(xExp, up, zExp))) {
                EntityLivingBase targetEntity = (EntityLivingBase)e;
                targetEntity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)11), protTime, amplifier, true, true));
            }
        }
    }

    private void emitAura(Entity entity, int numParticles, double xDist, double yDist, double zDist) {
        double v2;
        double v1;
        double d2;
        double d1;
        double d0;
        int i;
        World worldObj = entity.func_130014_f_();
        Random rand = worldObj.field_73012_v;
        for (i = 0; i < numParticles; ++i) {
            d0 = rand.nextGaussian() * 0.02;
            d1 = rand.nextGaussian() * 0.02;
            d2 = rand.nextGaussian() * 0.02;
            v1 = 2.0 * rand.nextDouble() - 1.0;
            v2 = 2.0 * rand.nextDouble() - 1.0;
            worldObj.func_175688_a(EnumParticleTypes.FLAME, entity.field_70165_t + v1 * ((double)entity.field_70130_N + xDist), entity.field_70163_u + 0.5 + rand.nextDouble() * ((double)entity.field_70131_O + yDist), entity.field_70161_v + v2 * ((double)entity.field_70130_N + zDist), d0, d1, d2, new int[0]);
        }
        for (i = 0; i < numParticles + 1; ++i) {
            d0 = rand.nextGaussian() * 0.015;
            d1 = rand.nextGaussian() * 0.015;
            d2 = rand.nextGaussian() * 0.015;
            v1 = (2.0 * rand.nextDouble() - 1.0) * 0.8;
            v2 = (2.0 * rand.nextDouble() - 1.0) * 0.8;
            worldObj.func_175688_a(EnumParticleTypes.PORTAL, entity.field_70165_t + v1 * ((double)entity.field_70130_N + xDist), entity.field_70163_u + 0.5 + rand.nextDouble() * ((double)entity.field_70131_O + yDist), entity.field_70161_v + v2 * ((double)entity.field_70130_N + zDist), d0, d1, d2, new int[0]);
        }
    }
}

