/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.custom.AbstractPower;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class LifeAura
extends AbstractPower {
    public LifeAura() {
        this.name = I18n.func_74838_a((String)"power.lifeAura");
    }

    @Override
    public EntityMagicalHorse.OrderedPower getOrderedPower() {
        return EntityMagicalHorse.OrderedPower.LIFE_AURA;
    }

    @Override
    public void doAuraPower(EntityMagicalHorse horse, int auraCounter) {
        int healTime = 1;
        int modCount1 = 30;
        int amplifier = 0;
        int modCount2 = 100;
        int modCount3 = 200;
        double xExp = 5.5;
        double up = 2.6;
        double zExp = 5.5;
        int numParticles = 3;
        this.emitAura((Entity)horse, numParticles, xExp / 2.0, up / 2.0, zExp / 2.0);
        if (auraCounter % modCount1 == 0) {
            for (int i = 0; i < 3; ++i) {
                this.spreadGrass((Entity)horse);
            }
        }
        if (auraCounter % modCount2 == 0) {
            this.spreadFlowers((Entity)horse);
        }
        if (auraCounter % modCount3 == 0) {
            for (Object e : horse.field_70170_p.func_72872_a(EntityLivingBase.class, horse.func_174813_aQ().func_72314_b(xExp, up, zExp))) {
                EntityLivingBase targetEntity = (EntityLivingBase)e;
                if (targetEntity instanceof IMob) continue;
                targetEntity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)6), healTime, amplifier, true, true));
                if (!(targetEntity instanceof EntityAnimal)) continue;
                targetEntity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)11), 100, 3, true, true));
                targetEntity.func_70690_d(new PotionEffect(Potion.func_188412_a((int)6), 10, 2, true, true));
            }
        }
    }

    private void spreadGrass(Entity entity) {
        World world = entity.func_130014_f_();
        Random rand = world.field_73012_v;
        double x = rand.nextGaussian() * 3.0;
        double z = rand.nextGaussian() * 3.0;
        BlockPos entityPos = entity.func_180425_c();
        BlockPos pos = world.func_175672_r(new BlockPos((Vec3i)entityPos.func_177963_a(x, 0.0, z))).func_177977_b();
        if (pos.func_177956_o() > entity.func_180425_c().func_177956_o() + 5) {
            pos = new BlockPos(pos.func_177958_n(), entityPos.func_177956_o() - 1, pos.func_177952_p()).func_177977_b();
        }
        Block b = world.func_180495_p(pos).func_177230_c();
        IBlockState upState = world.func_180495_p(pos.func_177984_a());
        Block up = upState.func_177230_c();
        if (!(Math.abs(pos.func_177956_o() - entityPos.func_177956_o()) >= 6 || Blocks.field_150346_d != b && Blocks.field_150354_m != b || upState.func_185904_a().func_76224_d() || upState.func_185904_a().func_76220_a())) {
            world.func_180501_a(pos, Blocks.field_150349_c.func_176223_P(), 3);
        }
    }

    private void spreadFlowers(Entity entity) {
        World world = entity.func_130014_f_();
        Random rand = world.field_73012_v;
        double x = rand.nextGaussian() * 3.0;
        double z = rand.nextGaussian() * 3.0;
        BlockPos entityPos = entity.func_180425_c();
        BlockPos pos = world.func_175672_r(new BlockPos((Vec3i)entityPos.func_177963_a(x, 0.0, z))).func_177977_b();
        if (pos.func_177956_o() > entity.func_180425_c().func_177956_o() + 5) {
            pos = new BlockPos(pos.func_177958_n(), entityPos.func_177956_o() - 1, pos.func_177952_p()).func_177977_b();
        }
        Block b = world.func_180495_p(pos).func_177230_c();
        IBlockState upState = world.func_180495_p(pos.func_177984_a());
        Block up = upState.func_177230_c();
        if (Math.abs(pos.func_177956_o() - entityPos.func_177956_o()) < 6 && Blocks.field_150349_c == b && !upState.func_185904_a().func_76224_d() && !upState.func_185904_a().func_76220_a() && up != Blocks.field_150328_O && up != Blocks.field_150327_N) {
            BlockFlower.EnumFlowerType flowerType = BlockFlower.EnumFlowerType.PINK_TULIP;
            int r = rand.nextInt(5);
            if (0 == r) {
                flowerType = BlockFlower.EnumFlowerType.ALLIUM;
            } else if (r < 4) {
                flowerType = world.func_180494_b(pos).func_180623_a(rand, pos);
            }
            BlockFlower blockFlower = flowerType.func_176964_a().func_180346_a();
            if (blockFlower.func_176223_P().func_185904_a() != Material.field_151579_a) {
                this.generateFlowers(world, rand, blockFlower, flowerType, pos);
            }
        }
    }

    public boolean generateFlowers(World worldIn, Random rand, BlockFlower blockFlower, BlockFlower.EnumFlowerType flowerType, BlockPos pos) {
        IBlockState state = blockFlower.func_176223_P().func_177226_a(blockFlower.func_176494_l(), (Comparable)flowerType);
        for (int i = 0; i < 5; ++i) {
            BlockPos blockpos1 = pos.func_177982_a(rand.nextInt(6) - rand.nextInt(6), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(6) - rand.nextInt(6));
            if (!worldIn.func_175623_d(blockpos1) || !worldIn.field_73011_w.func_191066_m() && blockpos1.func_177956_o() >= 255 || !blockFlower.func_180671_f(worldIn, blockpos1, state)) continue;
            worldIn.func_180501_a(blockpos1, state, 2);
        }
        return true;
    }

    private void emitAura(Entity entity, int numParticles, double xDist, double yDist, double zDist) {
        World world = entity.func_130014_f_();
        Random rand = world.field_73012_v;
        for (int i = 0; i < numParticles; ++i) {
            double d0 = rand.nextGaussian() * 0.2;
            double d1 = rand.nextGaussian() * 0.2;
            double d2 = rand.nextGaussian() * 0.2;
            world.func_175688_a(EnumParticleTypes.CRIT, entity.field_70165_t + (double)rand.nextFloat() * ((double)entity.field_70130_N + xDist) * 2.0 - ((double)entity.field_70130_N + xDist), entity.field_70163_u + 0.5 + (double)rand.nextFloat() * ((double)entity.field_70131_O + yDist), entity.field_70161_v + (double)rand.nextFloat() * ((double)entity.field_70130_N + zDist) * 2.0 - ((double)entity.field_70130_N + zDist), d0, d1, d2, new int[0]);
        }
    }
}

