/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.gui;

import com.hackshop.ultimate_unicorn.blocks.TileEntityMagicalHorseInventory;
import com.hackshop.ultimate_unicorn.items.ItemHelper;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.LocalPowerSettings;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiHorseConfig
extends GuiScreen {
    protected EntityMagicalHorse unicorn;
    private GuiButton doneBtn;
    private GuiButton cancelBtn;
    private final GuiScreen last;
    protected TileEntityMagicalHorseInventory tileEntity;
    protected int xSize = 176;
    protected int ySize = 166;
    protected int guiLeft;
    protected int guiTop;
    protected GuiButton[] buttonArray = new GuiButton[EntityMagicalHorse.OrderedPower.values().length];
    protected LocalPowerSettings localPowerSettings;
    private List powerListBox;
    private ArrayList<EntityMagicalHorse.OrderedPower> powerList;
    private int selectedIndex;
    private static final int BUTTON_HEIGHT = 13;
    private static final int LIST_WIDTH = 144;
    private static final int SCROLL_BAR_WIDTH = 6;
    private static final ResourceLocation panelImage = new ResourceLocation("ultimate_unicorn_mod:textures/gui/container/power_settings.png");

    public GuiHorseConfig(EntityMagicalHorse unicorn, TileEntityMagicalHorseInventory tileEntity, GuiScreen last) {
        this.unicorn = unicorn;
        this.last = last;
        this.tileEntity = tileEntity;
        this.localPowerSettings = unicorn.powerSettings.copy();
        this.powerList = unicorn.getAllPowerStrings();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.doneBtn = new GuiButton(100, this.field_146294_l / 2 - 4 - 150, this.field_146295_m * 10 / 11 - 13, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.doneBtn);
        this.cancelBtn = new GuiButton(101, this.field_146294_l / 2 + 4, this.field_146295_m * 10 / 11 - 13, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        this.field_146292_n.add(this.cancelBtn);
        this.powerListBox = new List(this.field_146297_k);
        this.powerListBox.func_148134_d(400, 500);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        int k = this.guiLeft;
        int l = this.guiTop;
        this.powerListBox.func_148128_a(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("ultimate_unicorn_mod:textures/gui/container/unicorn_inventory.png"));
        int x = this.guiLeft;
        int y = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(x, y, 0, 0, this.xSize, this.ySize);
        if (null == this.unicorn || this.unicorn.func_190695_dh()) {
            this.func_73729_b(x + 79 + 18, y + 17, 0, this.ySize, 72, 54);
        }
        this.func_73729_b(x + 7, y + 35, 0, this.ySize + 54, 18, 18);
        this.func_73729_b(x + 7, y + 35 + 18, 18, this.ySize + 54, 18, 18);
        this.func_73729_b(x + 79, y + 17, 13, this.ySize + 54, 18, 18);
        if (null == this.unicorn || this.unicorn.hasHorn() || this.tileEntity.func_70301_a(3) != null && ItemHelper.isSlottedHelm(this.tileEntity.func_70301_a(3).func_77973_b())) {
            this.func_73729_b(x + 79, y + 35, 54, this.ySize + 54, 18, 18);
        }
        if (null == this.unicorn || this.unicorn.hasWings()) {
            this.func_73729_b(x + 79, y + 35 + 18, 72, this.ySize + 54, 18, 18);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 100: {
                    this.unicorn.powerSettings.diffAndMessage(this.localPowerSettings);
                    this.field_146297_k.func_147108_a(this.last);
                    break;
                }
                case 101: {
                    this.field_146297_k.func_147108_a(this.last);
                    break;
                }
                default: {
                    this.powerListBox.func_148147_a(button);
                }
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode != 28 && keyCode != 156) {
            if (keyCode == 1) {
                this.func_146284_a(this.cancelBtn);
            }
        } else {
            this.func_146284_a(this.doneBtn);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.powerListBox.func_178039_p();
    }

    @SideOnly(value=Side.CLIENT)
    class List
    extends GuiSlot {
        private static final String __OBFID = "CL_00000712";
        protected float zLevel;

        public List(Minecraft mcIn) {
            super(mcIn, 144, GuiHorseConfig.this.field_146295_m, GuiHorseConfig.this.guiTop + 16, GuiHorseConfig.this.guiTop + 155, 13);
            this.zLevel = 0.0f;
            this.func_148140_g(GuiHorseConfig.this.guiLeft + 7);
        }

        public int func_148139_c() {
            return 144;
        }

        protected int func_148127_b() {
            return GuiHorseConfig.this.powerList.size();
        }

        public int func_148124_c(int xCoord, int yCoord) {
            int k = this.field_148152_e;
            int l = this.field_148152_e + this.field_148155_a;
            int i1 = yCoord - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
            int j1 = i1 / this.field_148149_f;
            return xCoord >= k && xCoord <= l && j1 >= 0 && i1 >= 0 && j1 < this.func_148127_b() ? j1 : -1;
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
            GuiHorseConfig.this.selectedIndex = slotIndex;
            EntityMagicalHorse.OrderedPower p = (EntityMagicalHorse.OrderedPower)((Object)GuiHorseConfig.this.powerList.get(slotIndex));
            GuiHorseConfig.this.localPowerSettings.toggle(p);
            if (isDoubleClick) {
                // empty if block
            }
        }

        public boolean func_148141_e(int p_148141_1_) {
            return p_148141_1_ >= this.field_148153_b && p_148141_1_ <= this.field_148154_c && (this.field_148150_g >= this.field_148152_e && this.field_148150_g <= this.field_148151_d || this.field_148150_g >= this.func_148137_d() && this.field_148150_g <= this.func_148137_d() + 6);
        }

        public void func_178039_p() {
            if (this.func_148141_e(this.field_148162_h)) {
                if (Mouse.isButtonDown((int)0) && this.func_148125_i()) {
                    if ((float)this.field_148157_o == -1.0f) {
                        boolean flag = true;
                        if (this.field_148162_h >= this.field_148153_b && this.field_148162_h <= this.field_148154_c) {
                            int i = this.field_148152_e;
                            int j = this.field_148152_e + this.field_148155_a;
                            int k = this.field_148162_h - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
                            int l = k / this.field_148149_f;
                            if (this.field_148150_g >= i && this.field_148150_g <= j && l >= 0 && k >= 0 && l < this.func_148127_b()) {
                                boolean flag1 = l == this.field_148168_r && Minecraft.func_71386_F() - this.field_148167_s < 250L;
                                this.func_148144_a(l, flag1, this.field_148150_g, this.field_148162_h);
                                this.field_148168_r = l;
                                this.field_148167_s = Minecraft.func_71386_F();
                            } else if (this.field_148150_g >= i && this.field_148150_g <= j && k < 0) {
                                this.func_148132_a(this.field_148150_g - i, this.field_148162_h - this.field_148153_b + (int)this.field_148169_q - 4);
                                flag = false;
                            }
                            int i2 = this.func_148137_d();
                            int i1 = i2 + 6;
                            if (this.field_148150_g >= i2 && this.field_148150_g <= i1) {
                                this.field_148170_p = -1.0f;
                                int j1 = this.func_148135_f();
                                if (j1 < 1) {
                                    j1 = 1;
                                }
                                int k1 = (int)((float)((this.field_148154_c - this.field_148153_b) * (this.field_148154_c - this.field_148153_b)) / (float)this.func_148138_e());
                                k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.field_148154_c - this.field_148153_b - 8));
                                this.field_148170_p /= (float)(this.field_148154_c - this.field_148153_b - k1) / (float)j1;
                            } else {
                                this.field_148170_p = 1.0f;
                            }
                            this.field_148157_o = flag ? this.field_148162_h : -2;
                        } else {
                            this.field_148157_o = -2;
                        }
                    } else if ((float)this.field_148157_o >= 0.0f) {
                        this.field_148169_q -= ((float)this.field_148162_h - (float)this.field_148157_o) * this.field_148170_p;
                        this.field_148157_o = this.field_148162_h;
                    }
                } else {
                    this.field_148157_o = -1;
                }
                int l1 = Mouse.getEventDWheel();
                if (l1 != 0) {
                    if (l1 > 0) {
                        l1 = -1;
                    } else if (l1 < 0) {
                        l1 = 1;
                    }
                    this.field_148169_q += (float)(l1 * this.field_148149_f / 2);
                }
            }
        }

        protected boolean func_148131_a(int slotIndex) {
            return slotIndex == GuiHorseConfig.this.selectedIndex;
        }

        protected int func_148138_e() {
            return GuiHorseConfig.this.powerList.size() * 13;
        }

        protected void func_148123_a() {
        }

        protected void func_192637_a(int entryID, int xPos, int yPos, int p_180791_4_, int mouseX, int mouseY, float f) {
            EntityMagicalHorse.OrderedPower orderedPower = (EntityMagicalHorse.OrderedPower)((Object)GuiHorseConfig.this.powerList.get(entryID));
            String s = orderedPower.getName() + (GuiHorseConfig.this.localPowerSettings.isEnabled(orderedPower) ? ": ON" : ": OFF");
            int color = 0xFFFFFF;
            if (this.isHoveringOverSlot(xPos, yPos, entryID, mouseX, mouseY)) {
                color = 0xFFFFA0;
            }
            GuiHorseConfig.this.func_73731_b(GuiHorseConfig.this.field_146289_q, s, xPos + 2, yPos + 1, color);
            GlStateManager.func_179131_c((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
        }

        protected int func_148137_d() {
            return this.field_148155_a + this.field_148152_e + 6;
        }

        protected void func_148136_c(int startY, int endY, int startAlpha, int endAlpha) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            this.field_148161_k.func_110434_K().func_110577_a(panelImage);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldrenderer.func_181662_b((double)this.field_148152_e, (double)endY, 0.0).func_187315_a(0.0, (double)((float)endY / 32.0f)).func_181669_b(64, 64, 64, endAlpha).func_181675_d();
            worldrenderer.func_181662_b((double)(this.field_148152_e + this.field_148155_a), (double)endY, 0.0).func_187315_a((double)((float)this.field_148155_a / 32.0f), (double)((float)endY / 32.0f)).func_181669_b(64, 64, 64, endAlpha).func_181675_d();
            worldrenderer.func_181662_b((double)(this.field_148152_e + this.field_148155_a), (double)startY, 0.0).func_187315_a((double)((float)this.field_148155_a / 32.0f), (double)((float)startY / 32.0f)).func_181669_b(64, 64, 64, startAlpha).func_181675_d();
            worldrenderer.func_181662_b((double)this.field_148152_e, (double)startY, 0.0).func_187315_a(0.0, (double)((float)startY / 32.0f)).func_181669_b(64, 64, 64, startAlpha).func_181675_d();
            tessellator.func_78381_a();
        }

        public void func_148128_a(int mouseXIn, int mouseYIn, float p_148128_3_) {
            this.field_148150_g = mouseXIn;
            this.field_148162_h = mouseYIn;
            this.func_148123_a();
            int k = this.func_148137_d();
            int l = k + 6;
            this.func_148121_k();
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            this.drawContainerBackground(tessellator);
            int i1 = this.field_148152_e;
            int j1 = this.field_148153_b + 4 - (int)this.field_148169_q;
            if (this.field_148165_u) {
                this.func_148129_a(i1, j1, tessellator);
            }
            this.drawSelectionBox(i1, j1, mouseXIn, mouseYIn);
            GlStateManager.func_179097_i();
            int b0 = 4;
            this.field_148161_k.func_110434_K().func_110577_a(panelImage);
            GuiHorseConfig.this.func_73729_b(GuiHorseConfig.this.guiLeft, GuiHorseConfig.this.guiTop, 0, 0, 240, 165);
            String title = I18n.func_135052_a((String)"horseSettingsUI.topTitle", (Object[])new Object[0]);
            GuiHorseConfig.this.field_146289_q.func_78276_b(title, GuiHorseConfig.this.guiLeft + GuiHorseConfig.this.xSize / 2 - GuiHorseConfig.this.field_146289_q.func_78256_a(title) / 2, this.field_148153_b - 10, 0x404040);
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)0, (int)1);
            GlStateManager.func_179118_c();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179090_x();
            int k1 = this.func_148135_f();
            if (k1 > 0) {
                int l1 = (this.field_148154_c - this.field_148153_b) * (this.field_148154_c - this.field_148153_b) / this.func_148138_e();
                int i2 = (int)this.field_148169_q * (this.field_148154_c - this.field_148153_b - (l1 = MathHelper.func_76125_a((int)l1, (int)32, (int)(this.field_148154_c - this.field_148153_b - 8)))) / k1 + this.field_148153_b;
                if (i2 < this.field_148153_b) {
                    i2 = this.field_148153_b;
                }
                worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                worldrenderer.func_181662_b((double)k, (double)this.field_148154_c, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                worldrenderer.func_181662_b((double)l, (double)this.field_148154_c, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                worldrenderer.func_181662_b((double)l, (double)this.field_148153_b, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                worldrenderer.func_181662_b((double)k, (double)this.field_148153_b, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                worldrenderer.func_181662_b((double)k, (double)(i2 + l1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                worldrenderer.func_181662_b((double)l, (double)(i2 + l1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                worldrenderer.func_181662_b((double)l, (double)i2, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                worldrenderer.func_181662_b((double)k, (double)i2, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                tessellator.func_78381_a();
                worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                worldrenderer.func_181662_b((double)k, (double)(i2 + l1 - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(162, 162, 162, 255).func_181675_d();
                worldrenderer.func_181662_b((double)(l - 1), (double)(i2 + l1 - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(162, 162, 162, 255).func_181675_d();
                worldrenderer.func_181662_b((double)(l - 1), (double)i2, 0.0).func_187315_a(1.0, 0.0).func_181669_b(162, 162, 162, 255).func_181675_d();
                worldrenderer.func_181662_b((double)k, (double)i2, 0.0).func_187315_a(0.0, 0.0).func_181669_b(162, 162, 162, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            this.func_148142_b(mouseXIn, mouseYIn);
            GlStateManager.func_179098_w();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
        }

        boolean isHoveringOverSlot(int xPos, int k1, int slotIndex, int mouseInX, int mouseInY) {
            return mouseInY >= k1 && mouseInY < k1 + this.field_148149_f && mouseInX >= xPos && mouseInX <= xPos + 144;
        }

        protected void drawSelectionBox(int xPos, int yPos, int mouseInX, int mouseInY) {
            int numSlots = this.func_148127_b();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            for (int slotIndex = 0; slotIndex < numSlots; ++slotIndex) {
                int k1 = yPos + slotIndex * this.field_148149_f + this.field_148160_j;
                int l1 = this.field_148149_f - 4;
                if (k1 < this.field_148153_b - 13 || k1 > this.field_148154_c) continue;
                if (this.field_148166_t) {
                    int[] color1 = new int[]{0, 0, 0};
                    int[] color2 = new int[]{128, 128, 128};
                    if (this.isHoveringOverSlot(xPos, k1, slotIndex, mouseInX, mouseInY)) {
                        color2 = new int[]{155, 155, 255};
                    }
                    int i2 = this.field_148152_e;
                    int j2 = this.field_148152_e + this.field_148155_a;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179090_x();
                    worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    worldrenderer.func_181662_b((double)i2, (double)(k1 + l1 + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(color1[0], color1[1], color1[2], 255).func_181675_d();
                    worldrenderer.func_181662_b((double)j2, (double)(k1 + l1 + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(color1[0], color1[1], color1[2], 255).func_181675_d();
                    worldrenderer.func_181662_b((double)j2, (double)(k1 - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(color1[0], color1[1], color1[2], 255).func_181675_d();
                    worldrenderer.func_181662_b((double)i2, (double)(k1 - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(color1[0], color1[1], color1[2], 255).func_181675_d();
                    worldrenderer.func_181662_b((double)(i2 + 1), (double)(k1 + l1 + 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(color2[0], color2[1], color2[2], 255).func_181675_d();
                    worldrenderer.func_181662_b((double)(j2 - 1), (double)(k1 + l1 + 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(color2[0], color2[1], color2[2], 255).func_181675_d();
                    worldrenderer.func_181662_b((double)(j2 - 1), (double)(k1 - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(color2[0], color2[1], color2[2], 255).func_181675_d();
                    worldrenderer.func_181662_b((double)(i2 + 1), (double)(k1 - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(color2[0], color2[1], color2[2], 255).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_179098_w();
                }
                this.func_192637_a(slotIndex, xPos, k1, l1, mouseInX, mouseInY, 0.0f);
            }
        }
    }
}

