/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.org.kamranzafar.jtar;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PermissionUtils {
    private static Map<PosixFilePermission, Integer> posixPermissionToInteger = new HashMap<PosixFilePermission, Integer>();
    private static final boolean isPosix;

    public static int permissions(File f) {
        if (f == null) {
            throw new NullPointerException("File is null.");
        }
        if (!f.exists()) {
            throw new IllegalArgumentException("File " + f + " does not exist.");
        }
        return isPosix ? PermissionUtils.posixPermissions(f) : PermissionUtils.standardPermissions(f);
    }

    private static int posixPermissions(File f) {
        int number = 0;
        try {
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(f.toPath(), new LinkOption[0]);
            for (Map.Entry<PosixFilePermission, Integer> entry : posixPermissionToInteger.entrySet()) {
                if (!permissions.contains((Object)entry.getKey())) continue;
                number += entry.getValue().intValue();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return number;
    }

    private static Set<StandardFilePermission> readStandardPermissions(File f) {
        HashSet<StandardFilePermission> permissions = new HashSet<StandardFilePermission>();
        if (f.canExecute()) {
            permissions.add(StandardFilePermission.EXECUTE);
        }
        if (f.canWrite()) {
            permissions.add(StandardFilePermission.WRITE);
        }
        if (f.canRead()) {
            permissions.add(StandardFilePermission.READ);
        }
        return permissions;
    }

    private static Integer standardPermissions(File f) {
        int number = 0;
        Set<StandardFilePermission> permissions = PermissionUtils.readStandardPermissions(f);
        for (StandardFilePermission permission : permissions) {
            number += permission.mode;
        }
        return number;
    }

    static {
        posixPermissionToInteger.put(PosixFilePermission.OWNER_EXECUTE, 64);
        posixPermissionToInteger.put(PosixFilePermission.OWNER_WRITE, 128);
        posixPermissionToInteger.put(PosixFilePermission.OWNER_READ, 256);
        posixPermissionToInteger.put(PosixFilePermission.GROUP_EXECUTE, 8);
        posixPermissionToInteger.put(PosixFilePermission.GROUP_WRITE, 16);
        posixPermissionToInteger.put(PosixFilePermission.GROUP_READ, 32);
        posixPermissionToInteger.put(PosixFilePermission.OTHERS_EXECUTE, 1);
        posixPermissionToInteger.put(PosixFilePermission.OTHERS_WRITE, 2);
        posixPermissionToInteger.put(PosixFilePermission.OTHERS_READ, 4);
        isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    private static enum StandardFilePermission {
        EXECUTE(72),
        WRITE(144),
        READ(288);

        private int mode;

        private StandardFilePermission(int mode) {
            this.mode = mode;
        }
    }
}

