/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord;

import chikachi.discord.core.Batcher;
import chikachi.discord.core.DiscordIntegrationLogger;
import chikachi.discord.core.Patterns;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.MessageChannel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.User;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;

@ParametersAreNonnullByDefault
public class DiscordCommandSender
extends FakePlayer {
    private static final UUID playerUUID = UUID.fromString("828653ca-0185-43d4-b26d-620a7f016be6");
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat(DiscordCommandSender.class.getSimpleName()).setDaemon(true).build());
    private final MessageChannel channel;
    private final Batcher<String> batcher = new Batcher(this::sendBatch, 100L, 10, executor);

    public DiscordCommandSender(MessageChannel channel, User user) {
        super(FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0], new GameProfile(playerUUID, "@" + user.getName()));
        this.channel = channel;
    }

    public DiscordCommandSender(WorldServer world, MessageChannel channel, String name) {
        super(world, new GameProfile(playerUUID, "@" + name));
        this.channel = channel;
    }

    public boolean func_70003_b(int i, String s) {
        return true;
    }

    public void func_145747_a(ITextComponent component) {
        Preconditions.checkNotNull((Object)component);
        this.batcher.queue(DiscordCommandSender.textComponentToDiscordMessage(component));
    }

    public void func_146105_b(ITextComponent component, boolean actionBar) {
        Preconditions.checkNotNull((Object)component);
        this.batcher.queue(DiscordCommandSender.textComponentToDiscordMessage(component));
    }

    private static String textComponentToDiscordMessage(ITextComponent component) {
        return Patterns.minecraftCodePattern.matcher(component.func_150260_c()).replaceAll("");
    }

    private void sendBatch(List<String> messages) {
        int numMessages = messages.size();
        this.channel.sendMessage(Joiner.on((String)"\n").join(messages)).submit().exceptionally(t -> {
            DiscordIntegrationLogger.Log("Exception sending " + numMessages + " messages to Discord:\n" + Throwables.getStackTraceAsString((Throwable)t), true);
            return null;
        });
    }
}

