/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.command;

import chikachi.discord.DiscordCommandSender;
import chikachi.discord.core.CoreUtils;
import chikachi.discord.core.MinecraftFormattingCodes;
import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeSet;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

class SubCommandTps {
    private static final DecimalFormat timeFormatter = new DecimalFormat("########0.000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    SubCommandTps() {
    }

    static void execute(ICommandSender sender, ArrayList<String> args) {
        String color;
        boolean isDiscord = sender instanceof DiscordCommandSender;
        boolean colored = args.stream().anyMatch(arg -> arg.equalsIgnoreCase("--color"));
        MinecraftServer minecraftServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        ArrayList<String> tpsTimes = new ArrayList<String>();
        Integer[] dimensionIds = DimensionManager.getIDs();
        HashMap<Integer, String> dimensionMap = new HashMap<Integer, String>();
        for (Integer dimensionId : dimensionIds) {
            dimensionMap.put(dimensionId, DimensionManager.getProviderType((int)dimensionId).func_186065_b());
        }
        int maxDimensionIdLength = Math.max(CoreUtils.getMinValue(dimensionMap.keySet()).toString().length(), CoreUtils.getMaxValue(dimensionMap.keySet()).toString().length());
        int maxDimensionNameLength = Math.max(CoreUtils.getMinLength(dimensionMap.values()), CoreUtils.getMaxLength(dimensionMap.values()));
        TreeSet sortedDimensionIds = new TreeSet(dimensionMap.keySet());
        for (Integer dimensionId : sortedDimensionIds) {
            String dimensionName = (String)dimensionMap.get(dimensionId);
            double worldTickTime = (double)CoreUtils.mean((long[])minecraftServer.worldTickTimes.get(dimensionId)) * 1.0E-6;
            double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
            color = colored && !isDiscord ? CoreUtils.tpsToColorString(worldTPS, false) : "";
            tpsTimes.add(String.format("%s%s : Mean tick time: %s%s ms. Mean TPS: %s%s", colored && isDiscord ? CoreUtils.tpsToColorString(worldTPS, true) : "", String.format("Dim %s %s", CoreUtils.padLeft(dimensionId + "", maxDimensionIdLength), CoreUtils.padRight(dimensionName, maxDimensionNameLength)), CoreUtils.padLeft(color + timeFormatter.format(worldTickTime), 6), isDiscord ? "" : MinecraftFormattingCodes.RESET, CoreUtils.padLeft(color + timeFormatter.format(worldTPS), 6), isDiscord ? "" : MinecraftFormattingCodes.RESET));
        }
        double meanTickTime = (double)CoreUtils.mean(minecraftServer.field_71311_j) * 1.0E-6;
        double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
        color = colored && !isDiscord ? CoreUtils.tpsToColorString(meanTPS, false) : "";
        tpsTimes.add(String.format("%s%s : Mean tick time: %s%s ms. Mean TPS: %s%s", colored && isDiscord ? CoreUtils.tpsToColorString(meanTPS, true) : "", CoreUtils.padRight("Overall", maxDimensionIdLength + maxDimensionNameLength + 5), CoreUtils.padLeft(color + timeFormatter.format(meanTickTime), 6), isDiscord ? "" : MinecraftFormattingCodes.RESET, CoreUtils.padLeft(color + timeFormatter.format(meanTPS), 6), isDiscord ? "" : MinecraftFormattingCodes.RESET));
        sender.func_145747_a((ITextComponent)new TextComponentString(isDiscord ? String.format("\n```%s\n%s\n```", colored ? "diff" : "lua", Joiner.on((String)"\n").join(tpsTimes)).replace("\\:", ":") : Joiner.on((String)"\n").join(tpsTimes)));
    }
}

