/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core.config.linking;

import chikachi.discord.core.config.Configuration;
import com.google.gson.annotations.Since;
import java.util.Date;
import java.util.Random;
import java.util.UUID;

public class LinkingRequest {
    private static Random rand = new Random();
    @Since(value=3.0)
    private long discordId;
    @Since(value=3.0)
    private String code;
    @Since(value=3.0)
    private long expires;

    private LinkingRequest() {
    }

    static LinkingRequest create(long discordId) {
        LinkingRequest request = new LinkingRequest();
        request.discordId = discordId;
        request.generateCode();
        Configuration.getLinking().addRequest(request);
        return request;
    }

    public void generateCode() {
        this.code = String.format("%04d", rand.nextInt(10000));
        this.expires = new Date(System.currentTimeMillis() + 300000L).getTime();
    }

    public long getDiscordId() {
        return this.discordId;
    }

    public String getCode() {
        return this.code;
    }

    public boolean hasExpired() {
        return this.expires <= new Date().getTime();
    }

    public String expiresIn() {
        int seconds = (int)Math.max(0L, Math.floorDiv(this.expires - new Date().getTime(), 1000L));
        int minutes = Math.floorDiv(seconds, 60);
        return String.format("%02d:%02d", minutes, seconds -= minutes * 60);
    }

    public void executeLinking(UUID minecraftUUID) {
        Configuration.getLinking().executeRequest(this, minecraftUUID);
    }
}

