/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core.config.linking;

import chikachi.discord.core.config.Configuration;
import chikachi.discord.core.config.linking.LinkingRequest;
import com.google.gson.annotations.Since;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class LinkingWrapper {
    @Since(value=3.0)
    private HashMap<UUID, Long> linked = new HashMap();
    @Since(value=3.0)
    private List<LinkingRequest> requests = new ArrayList<LinkingRequest>();

    void addRequest(LinkingRequest request) {
        Configuration.getLinking().requests.add(request);
        Configuration.saveLinking();
    }

    void executeRequest(LinkingRequest request, UUID minecraftUUID) {
        LinkingWrapper linkingWrapper = Configuration.getLinking();
        linkingWrapper.linked.put(minecraftUUID, request.getDiscordId());
        linkingWrapper.requests.remove(request);
        Configuration.saveLinking();
    }

    public boolean isLinked(UUID minecraftId, long discordId) {
        return this.linked.containsKey(minecraftId) && this.linked.get(minecraftId) == discordId;
    }

    public UUID getMinecraftId(long discordId) {
        Optional<Map.Entry> link;
        if (this.linked.containsValue(discordId) && (link = this.linked.entrySet().stream().filter(uuidLongEntry -> (Long)uuidLongEntry.getValue() == discordId).findFirst()).isPresent()) {
            return (UUID)link.get().getKey();
        }
        return null;
    }

    public Long getDiscordId(UUID minecraftId) {
        if (this.linked.containsKey(minecraftId)) {
            return this.linked.get(minecraftId);
        }
        return null;
    }

    public LinkingRequest getRequest(long discordUserId) {
        Optional<LinkingRequest> request = this.requests.stream().filter(linkingRequest -> linkingRequest.getDiscordId() == discordUserId).findFirst();
        return request.orElseGet(() -> LinkingRequest.create(discordUserId));
    }

    public Optional<LinkingRequest> getRequestByCode(String code) {
        return this.requests.stream().filter(linkingRequest -> linkingRequest.getCode().equalsIgnoreCase(code)).findFirst();
    }

    public void removeLink(UUID minecraftUUID) {
        this.linked.remove(minecraftUUID);
        Configuration.saveLinking();
    }
}

