/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core.config.types;

import chikachi.discord.core.config.types.DimensionConfigType;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class DimensionConfigTypeAdapter
implements JsonSerializer<DimensionConfigType>,
JsonDeserializer<DimensionConfigType> {
    public JsonElement serialize(DimensionConfigType src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.isDisabled()) {
            return new JsonPrimitive(Boolean.valueOf(false));
        }
        if (src.isDefault()) {
            return new JsonPrimitive(Boolean.valueOf(true));
        }
        ArrayList<Integer> dimensions = src.getDimensions();
        if (dimensions == null) {
            return null;
        }
        if (dimensions.size() == 0) {
            return new JsonPrimitive(Boolean.valueOf(false));
        }
        if (dimensions.size() == 1) {
            return new JsonPrimitive((Number)dimensions.get(0));
        }
        JsonArray array = new JsonArray();
        for (Integer dimensionId : dimensions) {
            array.add((JsonElement)new JsonPrimitive((Number)dimensionId));
        }
        return array;
    }

    public DimensionConfigType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        DimensionConfigType dimensionConfigType = new DimensionConfigType();
        if (json.isJsonArray()) {
            ArrayList<Integer> dimensions = new ArrayList<Integer>();
            JsonArray array = json.getAsJsonArray();
            for (JsonElement element : array) {
                int intValue;
                JsonPrimitive primitive;
                if (!element.isJsonPrimitive() || !(primitive = (JsonPrimitive)element).isNumber() || (intValue = primitive.getAsInt()) <= 0) continue;
                dimensions.add(intValue);
            }
            dimensionConfigType.setDimensions(dimensions).setDefault(false).setDisabled(false);
        } else if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                int intValue = primitive.getAsInt();
                if (intValue > 0) {
                    dimensionConfigType.addDimension(intValue).setDefault(false).setDisabled(false);
                }
            } else if (primitive.isBoolean()) {
                if (primitive.getAsBoolean()) {
                    dimensionConfigType.setDefault(true).setDisabled(false);
                } else {
                    dimensionConfigType.setDefault(false).setDisabled(true);
                }
            }
        }
        return dimensionConfigType;
    }
}

