/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.listener;

import chikachi.discord.core.CoreUtils;
import chikachi.discord.core.DiscordClient;
import chikachi.discord.core.Message;
import chikachi.discord.core.config.Configuration;
import chikachi.discord.core.config.minecraft.MinecraftConfig;
import chikachi.discord.core.config.minecraft.MinecraftDimensionConfig;
import chikachi.discord.core.config.minecraft.MinecraftGenericConfig;
import chikachi.discord.core.config.types.MessageConfig;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.User;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class MinecraftListener {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCommand(CommandEvent event) {
        ArrayList<Long> channels;
        MessageConfig messageConfig;
        if (event.isCanceled()) {
            return;
        }
        String commandName = event.getCommand().func_71517_b();
        ICommandSender sender = event.getSender();
        MinecraftConfig minecraftConfig = Configuration.getConfig().minecraft;
        MinecraftGenericConfig genericConfig = minecraftConfig.dimensions.generic;
        if (commandName.equalsIgnoreCase("say") || commandName.equalsIgnoreCase("me")) {
            ArrayList<Long> channels2;
            boolean isSayCommand = commandName.equalsIgnoreCase("say");
            if (isSayCommand && !Configuration.getConfig().minecraft.dimensions.generic.relaySayCommand) {
                return;
            }
            if (!isSayCommand && !Configuration.getConfig().minecraft.dimensions.generic.relayMeCommand) {
                return;
            }
            if (sender != null && Configuration.getConfig().minecraft.dimensions.generic.ignoreFakePlayerChat && sender instanceof FakePlayer) {
                return;
            }
            String message = Joiner.on((String)" ").join((Object[])event.getParameters());
            if (Configuration.getConfig().minecraft.dimensions.generic.isMessageIgnored(message)) {
                return;
            }
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("MESSAGE", isSayCommand ? message : "_" + message + "_");
            String prefix = minecraftConfig.dimensions.generic.chatPrefix;
            messageConfig = minecraftConfig.dimensions.generic.messages.chatMessage;
            if (sender != null) {
                Entity entity = sender.func_174793_f();
                if (entity != null) {
                    MinecraftDimensionConfig dimensionConfig = minecraftConfig.dimensions.getDimension(entity.field_71093_bK);
                    if (dimensionConfig.chatPrefix != null && dimensionConfig.chatPrefix.trim().length() > 0) {
                        prefix = dimensionConfig.chatPrefix;
                    }
                    if (dimensionConfig.messages.chatMessage != null) {
                        messageConfig = dimensionConfig.messages.chatMessage;
                    }
                    channels2 = dimensionConfig.relayChat.getChannels(genericConfig.relayChat.getChannels(dimensionConfig.discordChannel.getChannels(genericConfig.discordChannel)));
                } else {
                    channels2 = genericConfig.relayChat.getChannels(genericConfig.discordChannel);
                }
            } else {
                channels2 = genericConfig.relayChat.getChannels(genericConfig.discordChannel);
            }
            String authorName = null;
            String avatarUrl = null;
            if (sender != null) {
                authorName = sender.func_70005_c_();
                if (sender instanceof EntityPlayer) {
                    User discordUser;
                    avatarUrl = CoreUtils.getAvatarUrl(sender.func_70005_c_());
                    Long discordId = Configuration.getLinking().getDiscordId(((EntityPlayer)sender).func_146103_bH().getId());
                    if (discordId != null && (discordUser = DiscordClient.getInstance().getUser(discordId)) != null) {
                        authorName = discordUser.getName();
                        avatarUrl = discordUser.getAvatarUrl();
                    }
                }
            }
            DiscordClient.getInstance().broadcast(new Message().setAuthor(authorName).setAvatarUrl(avatarUrl).setMessage(messageConfig).setArguments(arguments).setPrefix(prefix), channels2);
        } else if (commandName.equalsIgnoreCase("discord") && event.getParameters().length > 0 && event.getParameters()[0].equalsIgnoreCase("link")) {
            return;
        }
        messageConfig = minecraftConfig.dimensions.generic.messages.command;
        if (sender != null) {
            Entity entity = sender.func_174793_f();
            if (entity != null) {
                MinecraftDimensionConfig dimensionConfig = minecraftConfig.dimensions.getDimension(entity.field_71093_bK);
                if (dimensionConfig.messages.command != null) {
                    messageConfig = dimensionConfig.messages.command;
                }
                channels = dimensionConfig.relayCommands.getChannels(genericConfig.relayCommands.getChannels(dimensionConfig.discordChannel.getChannels(genericConfig.discordChannel)));
            } else {
                channels = genericConfig.relayCommands.getChannels(genericConfig.discordChannel);
            }
        } else {
            channels = genericConfig.relayCommands.getChannels(genericConfig.discordChannel);
        }
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("COMMAND", event.getCommand().func_71517_b());
        arguments.put("ARGUMENTS", Joiner.on((String)" ").join((Object[])event.getParameters()));
        String authorName = null;
        String avatarUrl = null;
        if (sender != null) {
            authorName = sender.func_70005_c_();
            if (sender instanceof EntityPlayer) {
                User discordUser;
                avatarUrl = CoreUtils.getAvatarUrl(sender.func_70005_c_());
                Long discordId = Configuration.getLinking().getDiscordId(((EntityPlayer)sender).func_146103_bH().getId());
                if (discordId != null && (discordUser = DiscordClient.getInstance().getUser(discordId)) != null) {
                    authorName = discordUser.getName();
                    avatarUrl = discordUser.getAvatarUrl();
                }
            }
        }
        DiscordClient.getInstance().broadcast(new Message().setAuthor(authorName).setAvatarUrl(avatarUrl).setMessage(messageConfig).setArguments(arguments).setParsing(false), channels);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChatMessage(ServerChatEvent event) {
        User discordUser;
        if (event.isCanceled() || event.getPlayer() == null) {
            return;
        }
        if (Configuration.getConfig().minecraft.dimensions.generic.ignoreFakePlayerChat && event.getPlayer() instanceof FakePlayer) {
            return;
        }
        if (Configuration.getConfig().minecraft.dimensions.generic.isMessageIgnored(event.getMessage())) {
            return;
        }
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("MESSAGE", event.getMessage());
        MinecraftConfig minecraftConfig = Configuration.getConfig().minecraft;
        MinecraftDimensionConfig dimensionConfig = minecraftConfig.dimensions.getDimension(event.getPlayer().field_71093_bK);
        MinecraftGenericConfig genericConfig = minecraftConfig.dimensions.generic;
        MessageConfig messageConfig = dimensionConfig.messages.chatMessage != null ? dimensionConfig.messages.chatMessage : genericConfig.messages.chatMessage;
        String authorName = event.getUsername();
        String avatarUrl = CoreUtils.getAvatarUrl(authorName);
        Long discordId = Configuration.getLinking().getDiscordId(event.getPlayer().func_146103_bH().getId());
        if (discordId != null && (discordUser = DiscordClient.getInstance().getUser(discordId)) != null) {
            authorName = discordUser.getName();
            avatarUrl = discordUser.getAvatarUrl();
        }
        DiscordClient.getInstance().broadcast(new Message().setAuthor(authorName).setAvatarUrl(avatarUrl).setMessage(messageConfig).setArguments(arguments).setPrefix(dimensionConfig.chatPrefix != null && dimensionConfig.chatPrefix.trim().length() > 0 ? dimensionConfig.chatPrefix : genericConfig.chatPrefix), dimensionConfig.relayChat.getChannels(genericConfig.relayChat.getChannels(dimensionConfig.discordChannel.getChannels(genericConfig.discordChannel))));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerAchievement(AdvancementEvent event) {
        EntityPlayer entityPlayer = event.getEntityPlayer();
        if (entityPlayer != null && entityPlayer instanceof EntityPlayerMP) {
            User discordUser;
            Advancement advancement = event.getAdvancement();
            DisplayInfo displayInfo = advancement.func_192068_c();
            if (displayInfo == null || !displayInfo.func_193220_i()) {
                return;
            }
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("ACHIEVEMENT", displayInfo.func_192297_a().func_150260_c());
            arguments.put("DESCRIPTION", I18n.func_74837_a((String)displayInfo.func_193222_b().func_150260_c(), (Object[])new Object[]{"KEY"}));
            MinecraftConfig minecraftConfig = Configuration.getConfig().minecraft;
            MinecraftDimensionConfig dimensionConfig = minecraftConfig.dimensions.getDimension(entityPlayer.field_71093_bK);
            MinecraftGenericConfig genericConfig = minecraftConfig.dimensions.generic;
            MessageConfig messageConfig = dimensionConfig.messages.achievement != null ? dimensionConfig.messages.achievement : genericConfig.messages.achievement;
            String authorName = entityPlayer.getDisplayNameString();
            String avatarUrl = CoreUtils.getAvatarUrl(authorName);
            Long discordId = Configuration.getLinking().getDiscordId(entityPlayer.func_146103_bH().getId());
            if (discordId != null && (discordUser = DiscordClient.getInstance().getUser(discordId)) != null) {
                authorName = discordUser.getName();
                avatarUrl = discordUser.getAvatarUrl();
            }
            DiscordClient.getInstance().broadcast(new Message().setAuthor(authorName).setAvatarUrl(avatarUrl).setMessage(messageConfig).setArguments(arguments), dimensionConfig.relayAchievements.getChannels(genericConfig.relayAchievements.getChannels(dimensionConfig.discordChannel.getChannels(genericConfig.discordChannel))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        User discordUser;
        if (event.isCanceled() || event.player == null) {
            return;
        }
        MinecraftConfig minecraftConfig = Configuration.getConfig().minecraft;
        MinecraftDimensionConfig dimensionConfig = minecraftConfig.dimensions.getDimension(event.player.field_71093_bK);
        MinecraftGenericConfig genericConfig = minecraftConfig.dimensions.generic;
        MessageConfig messageConfig = dimensionConfig.messages.playerJoin != null ? dimensionConfig.messages.playerJoin : genericConfig.messages.playerJoin;
        String authorName = event.player.getDisplayNameString();
        String avatarUrl = CoreUtils.getAvatarUrl(authorName);
        Long discordId = Configuration.getLinking().getDiscordId(event.player.func_146103_bH().getId());
        if (discordId != null && (discordUser = DiscordClient.getInstance().getUser(discordId)) != null) {
            authorName = discordUser.getName();
            avatarUrl = discordUser.getAvatarUrl();
        }
        DiscordClient.getInstance().broadcast(new Message().setAuthor(authorName).setAvatarUrl(avatarUrl).setMessage(messageConfig), dimensionConfig.relayPlayerJoin.getChannels(genericConfig.relayPlayerJoin.getChannels(dimensionConfig.discordChannel.getChannels(genericConfig.discordChannel))));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        User discordUser;
        if (event.isCanceled() || event.player == null) {
            return;
        }
        MinecraftConfig minecraftConfig = Configuration.getConfig().minecraft;
        MinecraftDimensionConfig dimensionConfig = minecraftConfig.dimensions.getDimension(event.player.field_71093_bK);
        MinecraftGenericConfig genericConfig = minecraftConfig.dimensions.generic;
        MessageConfig messageConfig = dimensionConfig.messages.playerLeave != null ? dimensionConfig.messages.playerLeave : genericConfig.messages.playerLeave;
        String authorName = event.player.getDisplayNameString();
        String avatarUrl = CoreUtils.getAvatarUrl(authorName);
        Long discordId = Configuration.getLinking().getDiscordId(event.player.func_146103_bH().getId());
        if (discordId != null && (discordUser = DiscordClient.getInstance().getUser(discordId)) != null) {
            authorName = discordUser.getName();
            avatarUrl = discordUser.getAvatarUrl();
        }
        DiscordClient.getInstance().broadcast(new Message().setAuthor(authorName).setAvatarUrl(avatarUrl).setMessage(messageConfig), dimensionConfig.relayPlayerLeave.getChannels(genericConfig.relayPlayerLeave.getChannels(dimensionConfig.discordChannel.getChannels(genericConfig.discordChannel))));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (event.isCanceled() || entityLiving == null) {
            return;
        }
        if (entityLiving instanceof EntityPlayer) {
            User discordUser;
            EntityPlayer entityPlayer = (EntityPlayer)entityLiving;
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("REASON", entityPlayer.func_110142_aN().func_151521_b().func_150260_c().replace(entityPlayer.getDisplayNameString(), "").trim());
            MinecraftConfig minecraftConfig = Configuration.getConfig().minecraft;
            MinecraftDimensionConfig dimensionConfig = minecraftConfig.dimensions.getDimension(entityLiving.field_71093_bK);
            MinecraftGenericConfig genericConfig = minecraftConfig.dimensions.generic;
            MessageConfig messageConfig = dimensionConfig.messages.playerDeath != null ? dimensionConfig.messages.playerDeath : genericConfig.messages.playerDeath;
            String authorName = entityPlayer.getDisplayNameString();
            String avatarUrl = CoreUtils.getAvatarUrl(authorName);
            Long discordId = Configuration.getLinking().getDiscordId(entityPlayer.func_146103_bH().getId());
            if (discordId != null && (discordUser = DiscordClient.getInstance().getUser(discordId)) != null) {
                authorName = discordUser.getName();
                avatarUrl = discordUser.getAvatarUrl();
            }
            DiscordClient.getInstance().broadcast(new Message().setAuthor(authorName).setAvatarUrl(avatarUrl).setMessage(messageConfig).setArguments(arguments), dimensionConfig.relayPlayerDeath.getChannels(genericConfig.relayPlayerDeath.getChannels(dimensionConfig.discordChannel.getChannels(genericConfig.discordChannel))));
        }
    }
}

