/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.client.handle;

import chikachi.discord.repack.net.dv8tion.jda.client.entities.impl.CallImpl;
import chikachi.discord.repack.net.dv8tion.jda.client.entities.impl.CallUserImpl;
import chikachi.discord.repack.net.dv8tion.jda.client.entities.impl.GroupImpl;
import chikachi.discord.repack.net.dv8tion.jda.client.events.group.GroupUserJoinEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.User;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.EventCache;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.SocketHandler;
import chikachi.discord.repack.org.json.JSONObject;

public class ChannelRecipientAddHandler
extends SocketHandler {
    public ChannelRecipientAddHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long groupId = content.getLong("channel_id");
        JSONObject userJson = content.getJSONObject("user");
        GroupImpl group = (GroupImpl)this.api.asClient().getGroupById(groupId);
        if (group == null) {
            this.api.getEventCache().cache(EventCache.Type.CHANNEL, groupId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a CHANNEL_RECIPIENT_ADD for a group that is not yet cached! JSON: {}", (Object)content);
            return null;
        }
        User user = this.api.getEntityBuilder().createFakeUser(userJson, true);
        group.getUserMap().put(user.getIdLong(), user);
        CallImpl call = (CallImpl)group.getCurrentCall();
        if (call != null) {
            call.getCallUserMap().put(user.getIdLong(), new CallUserImpl(call, user));
        }
        this.api.getEventManager().handle(new GroupUserJoinEvent(this.api, this.responseNumber, group, user));
        this.api.getEventCache().playbackCache(EventCache.Type.USER, user.getIdLong());
        return null;
    }
}

