/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.audio.factory;

import chikachi.discord.repack.net.dv8tion.jda.core.audio.AudioConnection;
import chikachi.discord.repack.net.dv8tion.jda.core.audio.factory.IAudioSendSystem;
import chikachi.discord.repack.net.dv8tion.jda.core.audio.factory.IPacketProvider;
import chikachi.discord.repack.net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.JDALogger;
import chikachi.discord.repack.org.slf4j.MDC;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;

public class DefaultSendSystem
implements IAudioSendSystem {
    private final IPacketProvider packetProvider;
    private Thread sendThread;
    private ConcurrentMap<String, String> contextMap;

    public DefaultSendSystem(IPacketProvider packetProvider) {
        this.packetProvider = packetProvider;
    }

    @Override
    public void setContextMap(@CheckForNull ConcurrentMap<String, String> contextMap) {
        this.contextMap = contextMap;
    }

    @Override
    public void start() {
        DatagramSocket udpSocket = this.packetProvider.getUdpSocket();
        this.sendThread = new Thread(AudioManagerImpl.AUDIO_THREADS, () -> {
            if (this.contextMap != null) {
                MDC.setContextMap(this.contextMap);
            }
            long lastFrameSent = System.currentTimeMillis();
            while (!udpSocket.isClosed() && !this.sendThread.isInterrupted()) {
                try {
                    boolean changeTalking = System.currentTimeMillis() - lastFrameSent > 20L;
                    DatagramPacket packet = this.packetProvider.getNextPacket(changeTalking);
                    if (packet == null) continue;
                    udpSocket.send(packet);
                }
                catch (NoRouteToHostException e) {
                    this.packetProvider.onConnectionLost();
                }
                catch (SocketException e) {
                }
                catch (Exception e) {
                    AudioConnection.LOG.error("Error while sending udp audio data", e);
                }
                finally {
                    long sleepTime = 20L - (System.currentTimeMillis() - lastFrameSent);
                    if (sleepTime > 0L) {
                        try {
                            Thread.sleep(sleepTime);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (System.currentTimeMillis() < lastFrameSent + 60L) {
                        lastFrameSent += 20L;
                        continue;
                    }
                    lastFrameSent = System.currentTimeMillis();
                }
            }
        });
        this.sendThread.setUncaughtExceptionHandler((thread, throwable) -> {
            JDALogger.getLog(DefaultSendSystem.class).error("Uncaught exception in audio send thread", throwable);
            this.start();
        });
        this.sendThread.setDaemon(true);
        this.sendThread.setName(this.packetProvider.getIdentifier() + " Sending Thread");
        this.sendThread.setPriority(7);
        this.sendThread.start();
    }

    @Override
    public void shutdown() {
        if (this.sendThread != null) {
            this.sendThread.interrupt();
        }
    }
}

