/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.entities;

import chikachi.discord.repack.net.dv8tion.jda.client.entities.Group;
import chikachi.discord.repack.net.dv8tion.jda.core.JDA;
import chikachi.discord.repack.net.dv8tion.jda.core.Permission;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Channel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.ChannelType;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Emote;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Guild;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.ISnowflake;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.MessageChannel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.PrivateChannel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.TextChannel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.User;
import chikachi.discord.repack.net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import chikachi.discord.repack.net.dv8tion.jda.core.exceptions.PermissionException;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Request;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Response;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.RestAction;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Route;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.restaction.pagination.ReactionPaginationAction;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.MiscUtil;
import java.util.Objects;
import javax.annotation.CheckReturnValue;

public class MessageReaction {
    private final MessageChannel channel;
    private final ReactionEmote emote;
    private final long messageId;
    private final boolean self;
    private final int count;

    public MessageReaction(MessageChannel channel, ReactionEmote emote, long messageId, boolean self, int count) {
        this.channel = channel;
        this.emote = emote;
        this.messageId = messageId;
        this.self = self;
        this.count = count;
    }

    public JDA getJDA() {
        return this.channel.getJDA();
    }

    public boolean isSelf() {
        return this.self;
    }

    public int getCount() {
        if (this.count < 0) {
            throw new IllegalStateException("Cannot retrieve count for this MessageReaction!");
        }
        return this.count;
    }

    public ChannelType getChannelType() {
        return this.channel.getType();
    }

    public boolean isFromType(ChannelType type) {
        return this.getChannelType() == type;
    }

    public Guild getGuild() {
        TextChannel channel = this.getTextChannel();
        return channel != null ? channel.getGuild() : null;
    }

    public TextChannel getTextChannel() {
        return this.getChannel() instanceof TextChannel ? (TextChannel)this.getChannel() : null;
    }

    public PrivateChannel getPrivateChannel() {
        return this.getChannel() instanceof PrivateChannel ? (PrivateChannel)this.getChannel() : null;
    }

    public Group getGroup() {
        return this.getChannel() instanceof Group ? (Group)this.getChannel() : null;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public ReactionEmote getReactionEmote() {
        return this.emote;
    }

    public String getMessageId() {
        return Long.toUnsignedString(this.messageId);
    }

    public long getMessageIdLong() {
        return this.messageId;
    }

    @CheckReturnValue
    public ReactionPaginationAction getUsers() {
        return this.getUsers(100);
    }

    @CheckReturnValue
    public ReactionPaginationAction getUsers(int amount) {
        return (ReactionPaginationAction)new ReactionPaginationAction(this).limit(amount);
    }

    @CheckReturnValue
    public RestAction<Void> removeReaction() {
        return this.removeReaction(this.getJDA().getSelfUser());
    }

    @CheckReturnValue
    public RestAction<Void> removeReaction(User user) {
        if (user == null) {
            throw new IllegalArgumentException("Provided User was null!");
        }
        if (!user.equals(this.getJDA().getSelfUser())) {
            if (this.channel.getType() == ChannelType.TEXT) {
                Channel channel = (Channel)((Object)this.channel);
                if (!channel.getGuild().getSelfMember().hasPermission(channel, Permission.MESSAGE_MANAGE)) {
                    throw new InsufficientPermissionException(Permission.MESSAGE_MANAGE);
                }
            } else {
                throw new PermissionException("Unable to remove Reaction of other user in non-text channel!");
            }
        }
        String code = this.emote.isEmote() ? this.emote.getName() + ":" + this.emote.getId() : MiscUtil.encodeUTF8(this.emote.getName());
        Route.CompiledRoute route = user.equals(this.getJDA().getSelfUser()) ? Route.Messages.REMOVE_OWN_REACTION.compile(this.channel.getId(), this.getMessageId(), code) : Route.Messages.REMOVE_REACTION.compile(this.channel.getId(), this.getMessageId(), code, user.getId());
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MessageReaction)) {
            return false;
        }
        MessageReaction r = (MessageReaction)obj;
        return r.emote.equals(this.emote) && r.self == this.self && r.messageId == this.messageId;
    }

    public String toString() {
        return "MR:(M:(" + this.messageId + ") / " + this.emote + ")";
    }

    public static class ReactionEmote
    implements ISnowflake {
        private final JDA api;
        private final String name;
        private final Long id;
        private Emote emote = null;

        public ReactionEmote(String name, Long id, JDA api) {
            this.name = name;
            this.id = id;
            this.api = api;
        }

        public ReactionEmote(Emote emote) {
            this(emote.getName(), emote.getIdLong(), emote.getJDA());
            this.emote = emote;
        }

        public boolean isEmote() {
            return this.emote != null;
        }

        @Override
        public String getId() {
            return this.id != null ? String.valueOf(this.id) : null;
        }

        @Override
        public long getIdLong() {
            if (this.id == null) {
                throw new IllegalStateException("No id available");
            }
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Emote getEmote() {
            return this.emote;
        }

        public JDA getJDA() {
            return this.api;
        }

        public boolean equals(Object obj) {
            return obj instanceof ReactionEmote && Objects.equals(((ReactionEmote)obj).id, this.id) && ((ReactionEmote)obj).getName().equals(this.name);
        }

        public String toString() {
            return "RE:" + (this.isEmote() ? this.getEmote() : this.getName() + "(" + this.id + ")");
        }
    }
}

