/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.entities.impl;

import chikachi.discord.repack.net.dv8tion.jda.client.entities.Call;
import chikachi.discord.repack.net.dv8tion.jda.core.AccountType;
import chikachi.discord.repack.net.dv8tion.jda.core.JDA;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.ChannelType;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Message;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.MessageEmbed;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.PrivateChannel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.User;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Request;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Response;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.RestAction;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Route;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.restaction.MessageAction;
import java.io.InputStream;

public class PrivateChannelImpl
implements PrivateChannel {
    private final long id;
    private final User user;
    private long lastMessageId;
    private Call currentCall = null;
    private boolean fake = false;

    public PrivateChannelImpl(long id, User user) {
        this.id = id;
        this.user = user;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public long getLatestMessageIdLong() {
        long messageId = this.lastMessageId;
        if (messageId < 0L) {
            throw new IllegalStateException("No last message id found.");
        }
        return messageId;
    }

    @Override
    public boolean hasLatestMessage() {
        return this.lastMessageId > 0L;
    }

    @Override
    public String getName() {
        return this.user.getName();
    }

    @Override
    public ChannelType getType() {
        return ChannelType.PRIVATE;
    }

    @Override
    public JDA getJDA() {
        return this.user.getJDA();
    }

    @Override
    public RestAction<Void> close() {
        Route.CompiledRoute route = Route.Channels.DELETE_CHANNEL.compile(this.getId());
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public boolean isFake() {
        return this.fake;
    }

    @Override
    public RestAction<Call> startCall() {
        return null;
    }

    @Override
    public Call getCurrentCall() {
        return this.currentCall;
    }

    @Override
    public MessageAction sendMessage(CharSequence text) {
        this.checkBot();
        return PrivateChannel.super.sendMessage(text);
    }

    @Override
    public MessageAction sendMessage(MessageEmbed embed) {
        this.checkBot();
        return PrivateChannel.super.sendMessage(embed);
    }

    @Override
    public MessageAction sendMessage(Message msg) {
        this.checkBot();
        return PrivateChannel.super.sendMessage(msg);
    }

    @Override
    public MessageAction sendFile(InputStream data, String fileName, Message message) {
        this.checkBot();
        return PrivateChannel.super.sendFile(data, fileName, message);
    }

    public PrivateChannelImpl setFake(boolean fake) {
        this.fake = fake;
        return this;
    }

    public PrivateChannelImpl setCurrentCall(Call currentCall) {
        this.currentCall = currentCall;
        return this;
    }

    public PrivateChannelImpl setLastMessageId(long id) {
        this.lastMessageId = id;
        return this;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        return obj instanceof PrivateChannelImpl && this.id == ((PrivateChannelImpl)obj).id;
    }

    public String toString() {
        return "PC:" + this.getUser().getName() + '(' + this.id + ')';
    }

    private void checkBot() {
        if (this.user.isBot() && this.getJDA().getAccountType() == AccountType.BOT) {
            throw new UnsupportedOperationException("Cannot send a private message between bots.");
        }
    }
}

