/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.handle;

import chikachi.discord.repack.net.dv8tion.jda.client.entities.Group;
import chikachi.discord.repack.net.dv8tion.jda.client.entities.Relationship;
import chikachi.discord.repack.net.dv8tion.jda.client.entities.RelationshipType;
import chikachi.discord.repack.net.dv8tion.jda.core.AccountType;
import chikachi.discord.repack.net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Guild;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.UserImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.events.guild.GuildLeaveEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.guild.GuildUnavailableEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.EventCache;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.SocketHandler;
import chikachi.discord.repack.net.dv8tion.jda.core.managers.AudioManager;
import chikachi.discord.repack.net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.WebSocketClient;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.Helpers;
import chikachi.discord.repack.org.json.JSONObject;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.set.hash.TLongHashSet;

public class GuildDeleteHandler
extends SocketHandler {
    public GuildDeleteHandler(JDAImpl api) {
        super(api);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Long handleInternally(JSONObject content) {
        TLongObjectMap<AudioManager> audioManagerMap;
        long id = content.getLong("id");
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(id);
        boolean unavailable = Helpers.optBoolean(content, "unavailable");
        if (guild == null) {
            WebSocketClient.LOG.debug("Received GUILD_DELETE for a Guild that is not currently cached. ID: {} unavailable: {}", (Object)id, (Object)unavailable);
            return null;
        }
        if (!guild.isAvailable() && unavailable) {
            return null;
        }
        if (this.api.getGuildLock().isLocked(id)) {
            return id;
        }
        if (unavailable) {
            guild.setAvailable(false);
            this.api.getEventManager().handle(new GuildUnavailableEvent(this.api, this.responseNumber, guild));
            return null;
        }
        this.api.getClient().removeAudioConnection(id);
        TLongObjectMap<AudioManager> tLongObjectMap = audioManagerMap = this.api.getAudioManagerMap();
        synchronized (tLongObjectMap) {
            AudioManagerImpl manager = (AudioManagerImpl)audioManagerMap.get(id);
            if (manager != null) {
                manager.closeAudioConnection(ConnectionStatus.DISCONNECTED_REMOVED_FROM_GUILD);
            }
            audioManagerMap.remove(id);
        }
        TLongHashSet memberIds = new TLongHashSet(guild.getMembersMap().keySet());
        for (Guild guildI : this.api.getGuilds()) {
            GuildImpl g = (GuildImpl)guildI;
            if (g.equals(guild)) continue;
            TLongIterator it = memberIds.iterator();
            while (it.hasNext()) {
                if (!g.getMembersMap().containsKey(it.next())) continue;
                it.remove();
            }
        }
        if (this.api.getAccountType() == AccountType.CLIENT) {
            TLongObjectMap<Relationship> relationships = this.api.asClient().getRelationshipMap();
            TLongIterator it = memberIds.iterator();
            while (it.hasNext()) {
                Relationship rel = relationships.get(it.next());
                if (rel == null || rel.getType() != RelationshipType.FRIEND) continue;
                it.remove();
            }
        }
        long selfId = this.api.getSelfUser().getIdLong();
        memberIds.forEach(memberId -> {
            if (memberId == selfId) {
                return true;
            }
            UserImpl user = (UserImpl)this.api.getUserMap().remove(memberId);
            if (user.hasPrivateChannel()) {
                PrivateChannelImpl priv = (PrivateChannelImpl)user.getPrivateChannel();
                user.setFake(true);
                priv.setFake(true);
                this.api.getFakeUserMap().put(user.getIdLong(), user);
                this.api.getFakePrivateChannelMap().put(priv.getIdLong(), priv);
            } else if (this.api.getAccountType() == AccountType.CLIENT) {
                for (Group grp : this.api.asClient().getGroups()) {
                    if (!grp.getNonFriendUsers().contains(user)) continue;
                    user.setFake(true);
                    this.api.getFakeUserMap().put(user.getIdLong(), user);
                    break;
                }
            }
            this.api.getEventCache().clear(EventCache.Type.USER, memberId);
            return true;
        });
        this.api.getGuildMap().remove(id);
        guild.getTextChannelCache().forEach(chan -> this.api.getTextChannelMap().remove(chan.getIdLong()));
        guild.getVoiceChannelCache().forEach(chan -> this.api.getVoiceChannelMap().remove(chan.getIdLong()));
        guild.getCategoryCache().forEach(chan -> this.api.getCategoryMap().remove(chan.getIdLong()));
        this.api.getEventManager().handle(new GuildLeaveEvent(this.api, this.responseNumber, guild));
        this.api.getEventCache().clear(EventCache.Type.GUILD, id);
        return null;
    }
}

