/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.requests;

import chikachi.discord.repack.net.dv8tion.jda.core.requests.Requester;
import chikachi.discord.repack.org.json.JSONArray;
import chikachi.discord.repack.org.json.JSONObject;
import chikachi.discord.repack.org.json.JSONTokener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class Response
implements Closeable {
    public static final int ERROR_CODE = -1;
    public static final String ERROR_MESSAGE = "ERROR";
    public final int code;
    public final String message;
    public final long retryAfter;
    private final InputStream body;
    private final okhttp3.Response rawResponse;
    private final Set<String> cfRays;
    private Object object;
    private boolean attemptedParsing = false;
    private Exception exception;

    protected Response(okhttp3.Response response, Exception exception, Set<String> cfRays) {
        this(response, response != null ? response.code() : -1, ERROR_MESSAGE, -1L, cfRays);
        this.exception = exception;
    }

    protected Response(okhttp3.Response response, int code, String message, long retryAfter, Set<String> cfRays) {
        this.rawResponse = response;
        this.code = code;
        this.message = message;
        this.exception = null;
        this.retryAfter = retryAfter;
        this.cfRays = cfRays;
        if (response == null) {
            this.body = null;
            return;
        }
        try {
            this.body = Requester.getBody(response);
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred while parsing the response for a RestAction", e);
        }
    }

    protected Response(long retryAfter, Set<String> cfRays) {
        this(null, 429, "TOO MANY REQUESTS", retryAfter, cfRays);
    }

    protected Response(okhttp3.Response response, long retryAfter, Set<String> cfRays) {
        this(response, response.code(), response.message(), retryAfter, cfRays);
    }

    @Nullable
    public JSONArray getArray() {
        return this.parseBody(JSONArray.class, stream -> new JSONArray(this.getTokenizer((InputStream)stream)));
    }

    @Nullable
    public JSONObject getObject() {
        return this.parseBody(JSONObject.class, stream -> new JSONObject(this.getTokenizer((InputStream)stream)));
    }

    @Nullable
    public String getString() {
        return this.parseBody(String.class, stream -> new BufferedReader(new InputStreamReader((InputStream)stream)).lines().collect(Collectors.joining()));
    }

    @Nullable
    public <T> T get(Class<T> clazz, Function<InputStream, T> parser) {
        return this.parseBody(clazz, parser);
    }

    public okhttp3.Response getRawResponse() {
        return this.rawResponse;
    }

    public Set<String> getCFRays() {
        return this.cfRays;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isError() {
        return this.code == -1;
    }

    public boolean isOk() {
        return this.code > 199 && this.code < 300;
    }

    public boolean isRateLimit() {
        return this.code == 429;
    }

    public String toString() {
        return this.exception == null ? "HTTPResponse[" + this.code + (this.object == null ? "" : ", " + this.object.toString()) + ']' : "HTTPException[" + this.exception.getMessage() + ']';
    }

    @Override
    public void close() {
        if (this.rawResponse != null) {
            this.rawResponse.close();
        }
    }

    private JSONTokener getTokenizer(InputStream stream) {
        return new JSONTokener(new InputStreamReader(stream));
    }

    @Nullable
    private <T> T parseBody(Class<T> clazz, Function<InputStream, T> parser) {
        T t;
        if (this.attemptedParsing) {
            if (this.object != null && clazz.isAssignableFrom(this.object.getClass())) {
                return clazz.cast(this.object);
            }
            return null;
        }
        this.attemptedParsing = true;
        if (this.body == null || this.rawResponse == null || this.rawResponse.body().contentLength() == 0L) {
            return null;
        }
        try {
            T t2 = parser.apply(this.body);
            this.object = t2;
            t = t2;
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred while parsing the response for a RestAction", e);
        }
        finally {
            try {
                this.body.close();
            }
            catch (IOException | NullPointerException exception) {}
        }
        return t;
    }
}

