/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.requests.restaction.order;

import chikachi.discord.repack.net.dv8tion.jda.core.entities.Category;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Channel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.ChannelType;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.restaction.order.ChannelOrderAction;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.Checks;
import java.util.Collection;
import javax.annotation.Nonnull;

public class CategoryOrderAction<T extends Channel>
extends ChannelOrderAction<T> {
    protected final Category category;

    public CategoryOrderAction(Category category, ChannelType type) {
        super(category.getGuild(), type, CategoryOrderAction.getChannelsOfType(category, type));
        this.category = category;
    }

    @Nonnull
    public Category getCategory() {
        return this.category;
    }

    @Override
    protected void validateInput(T entity) {
        Checks.notNull(entity, "Provided channel");
        Checks.check(this.getCategory().equals(entity.getParent()), "Provided channel's Category is not this Category!");
        Checks.check(this.orderList.contains(entity), "Provided channel is not in the list of orderable channels!");
    }

    @Nonnull
    private static Collection<? extends Channel> getChannelsOfType(Category category, ChannelType type) {
        Checks.notNull((Object)type, "ChannelType");
        Checks.notNull(category, "Category");
        switch (type) {
            case TEXT: {
                return category.getTextChannels();
            }
            case VOICE: {
                return category.getVoiceChannels();
            }
        }
        throw new IllegalArgumentException("Cannot order category with specified channel type " + (Object)((Object)type));
    }
}

