/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.webhook;

import chikachi.discord.repack.net.dv8tion.jda.core.AccountType;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Message;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.MessageEmbed;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.Checks;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.Helpers;
import chikachi.discord.repack.net.dv8tion.jda.webhook.WebhookMessage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class WebhookMessageBuilder {
    protected final StringBuilder content = new StringBuilder();
    protected final List<MessageEmbed> embeds = new LinkedList<MessageEmbed>();
    protected String username;
    protected String avatarUrl;
    protected String fileName;
    protected InputStream file;
    protected boolean isTTS;

    public WebhookMessageBuilder(Message message) {
        if (message != null) {
            this.embeds.addAll(message.getEmbeds());
            this.setContent(message.getContentRaw());
            this.isTTS = message.isTTS();
        }
    }

    public WebhookMessageBuilder() {
    }

    public boolean isEmpty() {
        return this.content.length() == 0 && this.embeds.isEmpty() && this.file == null;
    }

    public WebhookMessageBuilder reset() {
        this.content.setLength(0);
        this.embeds.clear();
        this.username = null;
        this.avatarUrl = null;
        this.fileName = null;
        this.file = null;
        this.isTTS = false;
        return this;
    }

    public WebhookMessageBuilder resetEmbeds() {
        this.embeds.clear();
        return this;
    }

    public WebhookMessageBuilder addEmbeds(MessageEmbed ... embeds) {
        Checks.notNull(embeds, "Embeds");
        for (MessageEmbed embed : embeds) {
            Checks.notNull(embed, "Embed");
            Checks.check(embed.isSendable(AccountType.BOT), "One of the provided embeds is empty or exceeds the maximum character count of %d!", (Object)6000);
            this.embeds.add(embed);
        }
        return this;
    }

    public WebhookMessageBuilder addEmbeds(Collection<MessageEmbed> embeds) {
        Checks.notNull(embeds, "Embeds");
        for (MessageEmbed embed : embeds) {
            Checks.notNull(embed, "Embed");
            Checks.check(embed.isSendable(AccountType.BOT), "One of the provided embeds is empty or exceeds the maximum character count of %d!", (Object)6000);
            this.embeds.add(embed);
        }
        return this;
    }

    public WebhookMessageBuilder setContent(String content) {
        Checks.check(content == null || content.length() <= 2000, "Content may not exceed 2000 characters!");
        if (content != null) {
            this.content.replace(0, content.length(), content);
        } else {
            this.content.setLength(0);
        }
        return this;
    }

    public WebhookMessageBuilder append(String content) {
        Checks.notNull(content, "Content");
        Checks.check(this.content.length() + content.length() <= 2000, "Content may not exceed 2000 characters!");
        this.content.append(content);
        return this;
    }

    public WebhookMessageBuilder setUsername(String username) {
        this.username = Helpers.isBlank(username) ? null : username;
        return this;
    }

    public WebhookMessageBuilder setAvatarUrl(String avatarUrl) {
        this.avatarUrl = Helpers.isBlank(avatarUrl) ? null : avatarUrl;
        return this;
    }

    public WebhookMessageBuilder setFile(File file) {
        return this.setFile(file, file == null ? null : file.getName());
    }

    public WebhookMessageBuilder setFile(File file, String fileName) {
        if (file == null) {
            this.file = null;
            this.fileName = null;
            return this;
        }
        Checks.check(file.canRead() && file.exists(), "File must exist and be readable!");
        Checks.notBlank(fileName, "File name");
        Checks.check(file.length() <= 0x800000L, "Provided data exceeds the maximum size of 8MB!");
        try {
            this.file = new FileInputStream(file);
            this.fileName = fileName;
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
        return this;
    }

    public WebhookMessageBuilder setFile(byte[] data, String fileName) {
        if (data == null) {
            this.fileName = null;
            this.file = null;
            return this;
        }
        Checks.notBlank(fileName, "File name");
        Checks.check(data.length <= 0x800000, "Provided data exceeds the maximum size of 8MB!");
        this.file = new ByteArrayInputStream(data);
        this.fileName = fileName;
        return this;
    }

    public WebhookMessageBuilder setFile(InputStream data, String fileName) {
        Checks.check(data == null || !Helpers.isBlank(fileName), "The provided file name must not be null, empty or blank!");
        this.file = data;
        this.fileName = fileName;
        return this;
    }

    public WebhookMessageBuilder setTTS(boolean tts) {
        this.isTTS = tts;
        return this;
    }

    public WebhookMessage build() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot build an empty message!");
        }
        return new WebhookMessage(this.username, this.avatarUrl, this.content.toString(), this.embeds, this.isTTS, this.file, this.fileName);
    }
}

